#include <alleggl.h>
#include <cal3d/cal3d.h>
#include "cmodel.h"
CModel::CModel() {}
CModel::~CModel() { }
bool  CModel::create(CalCoreModel* cm) {
  core=cm;
  x=y=z=ang=0.0;
  model.create(cm);
// attach all meshes to the model
  for(int meshId = 0; meshId < cm->getCoreMeshCount(); meshId++)
  {
    model.attachMesh(meshId);
  }

  // set the material set of the whole model
  model.setMaterialSet(0);

  // set initial animation state
  blend=0.3f;
  frame = 0;
  remain = cm->getCoreAnimation(frame)->getDuration() - blend;

  model.getMixer()->blendCycle(0, 1.0f, 0.0f);
  model.update(0.0);
  model.setLodLevel(0.1);
  return true;
}

void CModel::render(float el) {
//     // check if the time has come to blend to the next animation
//   if(core->getCoreAnimationCount() > 1)
//     {
//       if((remain-=el)<blend)
//       {
//         // get the next animation
//         frame = (frame + 1) % core->getCoreAnimationCount();

//         // fade in the new animation
// 	model.getMixer()->executeAction(frame, remain, blend);

//         // adjust the animation time left until next animation flip
//         remain=core->getCoreAnimation(frame)->getDuration() - blend;
// 	cerr<<remain<<' ';
//       }
//     }
  model.update(el);
  float ar=(ang-90)*3.14159/180.;
  x+=cos(ar)*el*50;
  y+=sin(ar)*el*50;
//   glDisable(GL_LIGHTING);
//   glBegin(GL_TRIANGLES);
//   glColor3f(1.0, 0.0, 0.0);
//   glVertex3f(x, y, 40.);
//   glVertex3f(x+cos(ar)*50, y+sin(ar)*50, 50.);
//   glVertex3f(x, y, 60.);
//   glEnd();
//   glEnable(GL_LIGHTING);
  // get the renderer of the model
  CalRenderer *pCalRenderer = model.getRenderer();

  // begin the rendering loop
  if(!pCalRenderer->beginRendering()) return;

  // we will use vertex arrays, so enable them
  glEnableClientState(GL_VERTEX_ARRAY);
  glEnableClientState(GL_NORMAL_ARRAY);
  glEnable(GL_DEPTH_TEST);
  glPushMatrix();
  glTranslatef(x, y, z);
  glRotatef(ang, 0., 0., 1.);

  // get the number of meshes
  int meshCount = pCalRenderer->getMeshCount();

  // render all meshes of the model
  for(int meshId = 0; meshId < meshCount; meshId++)
  {
    // get the number of submeshes
    int submeshCount= pCalRenderer->getSubmeshCount(meshId);

    // render all submeshes of the mesh
    for(int submeshId = 0; submeshId < submeshCount; submeshId++)
    {
      // select mesh and submesh for further data access
      if(pCalRenderer->selectMeshSubmesh(meshId, submeshId))
      {
        unsigned char meshColor[4];
        GLfloat materialColor[4];

        // set the material ambient color
        pCalRenderer->getAmbientColor(&meshColor[0]);
        materialColor[0] = meshColor[0] / 255.0f;  materialColor[1] = meshColor[1] / 255.0f; materialColor[2] = meshColor[2] / 255.0f; materialColor[3] = meshColor[3] / 255.0f;
        glMaterialfv(GL_FRONT, GL_AMBIENT, materialColor);

        // set the material diffuse color
        pCalRenderer->getDiffuseColor(&meshColor[0]);
        materialColor[0] = meshColor[0] / 255.0f;  materialColor[1] = meshColor[1] / 255.0f; materialColor[2] = meshColor[2] / 255.0f; materialColor[3] = meshColor[3] / 255.0f;
        glMaterialfv(GL_FRONT, GL_DIFFUSE, materialColor);

        // set the material specular color
        pCalRenderer->getSpecularColor(&meshColor[0]);
        materialColor[0] = meshColor[0] / 255.0f;  materialColor[1] = meshColor[1] / 255.0f; materialColor[2] = meshColor[2] / 255.0f; materialColor[3] = meshColor[3] / 255.0f;
        glMaterialfv(GL_FRONT, GL_SPECULAR, materialColor);

        // set the material shininess factor
        float shininess;
        shininess =50.;// pCalRenderer->getShininess();
        glMaterialfv(GL_FRONT, GL_SHININESS, &shininess);

        // get the transformed vertices of the submesh
        static float meshVertices[30000][3];
        int vertexCount;
        vertexCount = pCalRenderer->getVertices(&meshVertices[0][0]);
        // get the transformed normals of the submesh
        static float meshNormals[30000][3];
        pCalRenderer->getNormals(&meshNormals[0][0]);

        // get the texture coordinates of the submesh
        static float meshTextureCoordinates[30000][2];
        int textureCoordinateCount;
        textureCoordinateCount = pCalRenderer->getTextureCoordinates(0, &meshTextureCoordinates[0][0]);

        // get the faces of the submesh
        static int meshFaces[50000][3];
        int faceCount;
        faceCount = pCalRenderer->getFaces(&meshFaces[0][0]);

        // set the vertex and normal buffers
        glVertexPointer(3, GL_FLOAT, 0, &meshVertices[0][0]);
        glNormalPointer(GL_FLOAT, 0, &meshNormals[0][0]);

        // set the texture coordinate buffer and state if necessary
        if((pCalRenderer->getMapCount() > 0) && (textureCoordinateCount > 0))
        {
          glEnable(GL_TEXTURE_2D);
          glEnableClientState(GL_TEXTURE_COORD_ARRAY);
          glEnable(GL_COLOR_MATERIAL);

          // set the texture id we stored in the map user data
	  glBindTexture(GL_TEXTURE_2D, (GLuint)pCalRenderer->getMapUserData(0));

          // set the texture coordinate buffer
          glTexCoordPointer(2, GL_FLOAT, 0, &meshTextureCoordinates[0][0]);
          glColor3f(1.0f, 1.0f, 1.0f);
        }

        // draw the submesh
        glDrawElements(GL_TRIANGLES, faceCount * 3, GL_UNSIGNED_INT, &meshFaces[0][0]);

        // disable the texture coordinate state if necessary
        if((pCalRenderer->getMapCount() > 0) && (textureCoordinateCount > 0))
        {
          glDisable(GL_COLOR_MATERIAL);
          glDisableClientState(GL_TEXTURE_COORD_ARRAY);
          glDisable(GL_TEXTURE_2D);
        }
      }
    }
  }
  // clear vertex array state
  glDisableClientState(GL_NORMAL_ARRAY);
  glDisableClientState(GL_VERTEX_ARRAY);
  glBindTexture(GL_TEXTURE_2D, 0);
  glPopMatrix();
  // end the rendering
  pCalRenderer->endRendering();
}
CModelLoader::CModelLoader() {}
bool  CModelLoader::load(const char* cfg) {
  // open the model configuration file
  std::ifstream file;
  cerr<<"Pete's loader: "<< cfg<<endl;
  file.open(cfg, std::ios::in);
  if(!file)
  {
    std::cerr << "Failed to open model configuration file '" << cfg << "'." << std::endl;
    return false;
  }

  // create a core model instance
  if(!core.create("dummy"))
  {
    CalError::printLastError();
    return false;
  }
  char* slashpos=strrchr(cfg, '/');
  stem=slashpos ? string(cfg, slashpos-cfg+1) : "";
  // parse all lines from the model configuration file
  int line=0;
  while(!file.eof())
  {
  	++line;
    // read the next model configuration line
    std::string strBuffer;
    std::getline(file, strBuffer);

    // find the first non-whitespace character
    std::string::size_type pos;
    pos = strBuffer.find_first_not_of(" \t");

    // check for empty lines
    if((pos == std::string::npos) || (strBuffer[pos] == '\n') || (strBuffer[pos] == '\r') || (strBuffer[pos] == 0)) continue;

    // check for comment lines
    if(strBuffer[pos] == '#') continue;

    // get the key
    std::string strKey;
    strKey = strBuffer.substr(pos, strBuffer.find_first_of(" =\t\n\r", pos) - pos);
    pos += strKey.size();

    // get the '=' character
    pos = strBuffer.find_first_not_of(" \t", pos);
    if((pos == std::string::npos) || (strBuffer[pos] != '='))
    {
      std::cerr << cfg << "(" << line << "): Invalid syntax." << std::endl;
      return false;
    }

    // find the first non-whitespace character after the '=' character
    pos = strBuffer.find_first_not_of(" \t", pos + 1);

    // get the data
    std::string strData;
    strData = strBuffer.substr(pos, strBuffer.find_first_of("\n\r", pos) - pos);

    // handle the model creation
    if(strKey == "scale")
    {
      // set rendering scale factor
      scale = atof(strData.c_str());
    }
    else if(strKey == "skeleton")
    {
      // load core skeleton
//      std::cout << "Loading skeleton '" << strData << "'..." << std::endl;
      if(!core.loadCoreSkeleton(fqn(strData)))
      {
        CalError::printLastError();
        return false;
      }
    }
    else if(strKey == "animation")
    {
      // load core animation
//      std::cout << "Loading animation '" << strData << "'..." << std::endl;
      if(core.loadCoreAnimation(fqn(strData)) == -1)
      {
        CalError::printLastError();
        return false;
      }
    }
    else if(strKey == "mesh")
    {
      // load core mesh
//      std::cout << "Loading mesh '" << strData << "'..." << std::endl;
      if(core.loadCoreMesh(fqn(strData)) == -1)
      {
        CalError::printLastError();
        return false;
      }
    }
    else if(strKey == "material")
    {
      // load core material
//      std::cout << "Loading material '" << strData << "'..." << std::endl;
      if(core.loadCoreMaterial(fqn(strData)) == -1)
      {
        CalError::printLastError();
        return false;
      }
    }
    else
    {
      // everything else triggers an error message, but is ignored
      std::cerr << cfg << "(" << line << "): Invalid syntax." << std::endl;
    }
  }

  // explicitely close the file
  file.close();
  // make one material thread for each material
  // NOTE: this is not the right way to do it, but this viewer can't do the right
  // mapping without further information on the model etc., so this is the only
  // thing we can do here.
//  cerr<<"*material threads\n";
  int materialCount=core.getCoreMaterialCount();
  for(int materialId = 0; materialId < materialCount; materialId++)
  {
    // create the a material thread
    core.createCoreMaterialThread(materialId);

    // initialize the material thread
    core.setCoreMaterialId(materialId, 0, materialId);
  }

  for(int materialId = 0; materialId < materialCount; materialId++)
  {
    // get the core material
    CalCoreMaterial *pCoreMaterial = core.getCoreMaterial(materialId);

    // loop through all maps of the core material
    for(int mapId = 0; mapId < pCoreMaterial->getMapCount(); mapId++)
    {
      // get the filename of the texture
      std::string strFilename = pCoreMaterial->getMapFilename(mapId);

      // load the texture from the file
      GLuint textureId = loadTexture(strFilename);

      // store the opengl texture id in the user data of the map
      pCoreMaterial->setMapUserData(mapId, (Cal::UserData)textureId);
    }
  }
  return true;
}

GLuint CModelLoader::loadTexture(std::string strFilename) {
  // open the texture file
  std::ifstream file;
  file.open(fqn(strFilename).c_str(), std::ios::in | std::ios::binary);
  if(!file)
  {
//    std::cerr << "Texture file '" << strFilename << "' not found." << std::endl;
    return 0;
  }

  // load the dimension of the texture
  int width;
  file.read((char *)&width, 4);
  int height;
  file.read((char *)&height, 4);
  int depth;
  file.read((char *)&depth, 4);

  // allocate a temporary buffer to load the texture to
  unsigned char *pBuffer;
  pBuffer = new unsigned char[2 * width * height * depth];
  if(pBuffer == 0)
  {
    std::cerr << "Memory allocation for texture '" << strFilename << "' failed." << std::endl;
    return 0;
  }

  // load the texture
  file.read((char *)pBuffer, width * height * depth);

  // explicitely close the file
  file.close();

  // flip texture around y-axis (-> opengl-style)
  int y;
  for(y = 0; y < height; y++)
  {
    memcpy(&pBuffer[(height + y) * width * depth], &pBuffer[(height - y - 1) * width * depth], width * depth);
  }

  // generate texture
  glPixelStorei(GL_UNPACK_ALIGNMENT, 1);
  GLuint textureId;
  glGenTextures(1, &textureId);
  glBindTexture(GL_TEXTURE_2D, textureId);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_S, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_WRAP_T, GL_REPEAT);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MAG_FILTER, GL_LINEAR);
  glTexParameteri(GL_TEXTURE_2D, GL_TEXTURE_MIN_FILTER, GL_LINEAR);
  glTexImage2D(GL_TEXTURE_2D, 0, (depth == 3) ? GL_RGB : GL_RGBA, width, height, 0, (depth == 3) ? GL_RGB : GL_RGBA, GL_UNSIGNED_BYTE, &pBuffer[width * height * depth]);

  // free the allocated memory
  delete [] pBuffer;
  return textureId;
}

std::string CModelLoader::fqn(std::string s) {
  if (s[0]!='/')
    return stem+s;
  else
    return s;
}


