// -*- C++ -*-
class CModel {
 public:
  CModel();
  ~CModel();
  bool create(CalCoreModel*);
  void render(float anim);
  void destroy() {model.destroy();}
  void turn(float delta) {ang+=delta;}
  void turnto(float a) {ang=a;}
  void moveto(float xx, float yy, float zz) {
    x=xx; y=yy; z=zz; 
  }
  float getx() const {return x;}
  float gety() const {return y;}
  void doAnim(int id) {model.getMixer()->executeAction(id, 0.5, 2.5);}
 private:
  float x, y, z, ang;
  CalModel model;
  CalCoreModel* core;
  int frame;
  float remain, blend;
};

class CModelLoader {
 public:
  CModelLoader();
  ~CModelLoader() {}
  bool load(const char* cfg);
  CalCoreModel* coreModel() {return &core;}
  void destroy() {core.destroy();}
  float scale;
 private:
  GLuint loadTexture(std::string);
  std::string stem;
  std::string fqn(std::string);
  CalCoreModel core;
};
