#include <alleggl.h>
#include <GL/glu.h>
#include <cal3d/cal3d.h>
#include "cmodel.h"

void setup_gl();
void shutdown_gl();
void draw_scene();

volatile float ticks;
float timeslice;
void ticker() {
  ticks+=timeslice;
} END_OF_FUNCTION(ticker);
GLuint marble;

float mva(float a, float ta) {
  while (ta>=360.) ta-=360.;
  while (ta<0.) ta+=360.;
  while (a<0.) a+=360.;
  while (a>=360.) a-=360.;
  float d1=ta-a;
  float d2=ta-a-360;
  if (fabs(d1)<fabs(d2)) 
    return d1;
  else
    return d2;
}
  

int main(int argc, char* argv[]) {
  allegro_init();
  install_keyboard();
  setup_gl();
  set_color_depth(32);
  if (set_gfx_mode(GFX_OPENGL_WINDOWED, 640, 480, 0, 0)<0) {
    allegro_message("No mode: %s\n", allegro_error);
    return 1;
  }
  ticks=0.0;
  timeslice=0.01;
  install_int_ex(ticker, BPS_TO_TIMER(int(1.0/timeslice)));
  CModelLoader beest_ldr, paladin_ldr;
  if (!beest_ldr.load("beest/Beest.cfg")) {
  	set_gfx_mode(GFX_TEXT, 0,0,0,0);
  	allegro_message("Could not load model beest\n");
  	return 1;
  }
  if (!paladin_ldr.load("paladin/paladin.cfg")) {
	set_gfx_mode(GFX_TEXT, 0,0,0,0);
  	allegro_message("Could not load model paladin\n");
  	return 1;
  }
	
  int id=paladin_ldr.coreModel()->loadCoreAnimation("paladin/paladin_wave.caf");
  CModel beest, paladin;
  beest.create(beest_ldr.coreModel());
  paladin.create(paladin_ldr.coreModel());
  glEnable(GL_LIGHTING);
  glEnable(GL_LIGHT0);
  glEnable(GL_TEXTURE_2D);
  glEnable(GL_DEPTH_TEST);
  //  glEnable(GL_CULL_FACE);
  glCullFace(GL_BACK);
  GLuint castle=glGenLists(1);
  glNewList(castle, GL_COMPILE);
  draw_scene();
  glEndList();
  // light attributes
  const GLfloat light_ambient[]  = { 0.3f, 0.3f, 0.3f, 1.0f };
  const GLfloat light_diffuse[]  = { 0.52f, 0.5f, 0.5f, 1.0f };
  const GLfloat light_specular[] = { 0.8f, 0.8f, 0.8f, 1.0f };
  // setup the light attributes
  glLightfv(GL_LIGHT0, GL_AMBIENT, light_ambient);
  glLightfv(GL_LIGHT0, GL_DIFFUSE, light_diffuse);
  glLightfv(GL_LIGHT0, GL_SPECULAR, light_specular);
  glClearColor(0.3, 0.6, 0.4, 1.0);
  // set the light position
  GLfloat lightPosition[] = { 0.0f, 0.0f, 1.0f, 0.0f };

  allegro_gl_use_mipmapping(TRUE);
  BITMAP* bm=load_bitmap("marble.bmp", NULL);
  marble=allegro_gl_make_texture(bm);
  destroy_bitmap(bm);

/* set up projection */
  glMatrixMode(GL_PROJECTION);
  glLoadIdentity();
  gluPerspective(50., (GLdouble) SCREEN_W/(GLdouble) SCREEN_H, 6., 1000.);
/* setup view matrix */
  glMatrixMode(GL_MODELVIEW);
  allegro_gl_begin();
  float azi=45.0;
  beest.moveto(10, 10, 220);
  paladin.moveto(0,50,0);
  paladin.turnto(180);
  float tt=0, ta=0, tx=0, ty=0;
  float then=ticks;
  float el;
  float tickt=5; 
  
  while (!key[KEY_ESC]) {
    el=ticks-then;
    then=ticks;
    glClear(GL_COLOR_BUFFER_BIT|GL_DEPTH_BUFFER_BIT);
    glLoadIdentity();
    gluLookAt(700., 0., 200., beest.getx(), beest.gety(), 220., 0., 0., 1.);
    //gluLookAt(0., 0., 700., paladin.getx(), paladin.gety(), 0., 0., 1., 0.);
    //    glRotatef(45, -1., 0., 0.);
    glLightfv(GL_LIGHT0, GL_POSITION, lightPosition);
    glBindTexture(GL_TEXTURE_2D, marble);
    glCallList(castle);
    glBindTexture(GL_TEXTURE_2D, 0);
    float fac=el;
    if (fac>1.) fac=1.;
    tt+=fac*mva(tt, ta);
    paladin.turnto(tt);
    if (tickt<ticks) {
      tx=float(rand()%300-150);
      ty=float(rand()%300-150);
      tickt+=3;
    }
    ta=180.0/3.141*atan2(ty-paladin.gety(), tx-paladin.getx())+90.;
    if (key[KEY_W]) {
      paladin.doAnim(id);
    }
    beest.turn(0.2);
    beest.render(el);
    paladin.render(el);

    allegro_gl_flip();
    allegro_gl_end();
  }
  beest.destroy();
  paladin.destroy();
  beest_ldr.destroy();
  paladin_ldr.destroy();
  glDeleteLists(castle, 1);
  set_gfx_mode(GFX_TEXT, 0, 0, 0, 0);
  shutdown_gl();
  return 0;
} END_OF_MAIN();

void cube(GLint top) {
  GLfloat tx=GLfloat(top)/20.0;
  const GLint wid=10;
  glBegin(GL_QUADS);
  //1
  glNormal3f(-1., 0., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(-wid, -wid, 0);
    glTexCoord2f(tx, 0.);
    glVertex3i(-wid, -wid,top);
    glTexCoord2f(tx, 1.);
    glVertex3i(-wid, wid, top);
    glTexCoord2f(0., 1.);
    glVertex3i(-wid, wid, 0);
    //2
    glNormal3f(1., 0., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(wid, -wid, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(wid, wid,0);
    glTexCoord2f(1., tx);
    glVertex3i(wid, wid, top);
    glTexCoord2f(0., tx);
    glVertex3i(wid, -wid, top);
  //3
  glNormal3f(0., -1., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(-wid, -wid, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(wid, -wid, 0);
    glTexCoord2f(1., tx);
    glVertex3i(wid, -wid, top);
    glTexCoord2f(0., tx);
    glVertex3i(-wid, -wid, top);
    //4
    glNormal3f(0., 1., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(wid, wid, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(-wid, wid,0);
    glTexCoord2f(1., tx);
    glVertex3i(-wid, wid, top);
    glTexCoord2f(0., tx);
    glVertex3i(wid, wid, top);
    //5
    glNormal3f(0., 0., 1.);
    glTexCoord2f(0., 0.);
    glVertex3i(-wid, -wid, top);
    glTexCoord2f(1., 0.);
    glVertex3i(wid, -wid,top);
    glTexCoord2f(1., 1.);
    glVertex3i(wid, wid, top);
    glTexCoord2f(0., 1.);
    glVertex3i(-wid, wid, top);
    glEnd();
}
void cuberow(int dx, int dy) {
  for (int i=0; i<10; ++i) {
    cube(40);
    glTranslatef(dx, dy, 0);
    cube(20);
    glTranslatef(dx, dy, 0);
  }
}
void draw_scene() {
  static GLfloat bg[]={0.6, 0.7, 0.7, 1.0};
  static GLfloat bl[]={1.0, 1.0, 1.0, 1.0};
  //  glColor3f(1.0, 1.0, 1.0);
  glMaterialfv(GL_FRONT, GL_AMBIENT_AND_DIFFUSE, bg);
  glMaterialfv(GL_FRONT, GL_SPECULAR, bl);
  glEnable(GL_TEXTURE_2D);
  //  cube(100);
  glBegin(GL_QUADS);
  for (int i=-200; i<200; i+=20) {
    for (int j=-200; j<200; j+=20) {
      glNormal3f(0., 0., 1.0);
      glTexCoord2f(0., 0.);
      glVertex2i(i,j);
      glTexCoord2f(1., 0.);
      glVertex2i(i+20,j);
      glTexCoord2f(1., 1.);
      glVertex2i(i+20,j+20);
      glTexCoord2f(0., 1.);
      glVertex2i(i,j+20);
    }
  }
  //1
  glNormal3f(-1., 0., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(-200, -200, -500);
    glTexCoord2f(1., 0.);
    glVertex3i(-200, -200,0);
    glTexCoord2f(1., 1.);
    glVertex3i(-200, 200, 0);
    glTexCoord2f(0., 1.);
    glVertex3i(-200, 200, -500);
    //2
    glNormal3f(1., 0., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(200, -200, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(200, 200,0);
    glTexCoord2f(1., 1.);
    glVertex3i(200, 200,-500);
    glTexCoord2f(0., 1.);
    glVertex3i(200, -200, -500);
  //3
  glNormal3f(0., -1., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(-200, -200, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(200, -200, 0);
    glTexCoord2f(1., 1.);
    glVertex3i(200, -200, -500);
    glTexCoord2f(0., 1.);
    glVertex3i(-200, -200, -500);
    //4
    glNormal3f(0., 1., 0.);
    glTexCoord2f(0., 0.);
    glVertex3i(200, 200, 0);
    glTexCoord2f(1., 0.);
    glVertex3i(-200, 200,0);
    glTexCoord2f(1., 1.);
    glVertex3i(-200, 200, -500);
    glTexCoord2f(0., 1.);
    glVertex3i(200, 200, -500);
  glEnd();
  glPushMatrix();
  glTranslatef(-200,-200,0);
  cuberow(20,0);
  cuberow(0,20);
  cuberow(-20,0);
  cuberow(0,-20);
  glPopMatrix();
}
void setup_gl() {
  install_allegro_gl();
  allegro_gl_clear_settings();
  allegro_gl_set (AGL_COLOR_DEPTH, 32);
  allegro_gl_set (AGL_Z_DEPTH, 16);
  allegro_gl_set (AGL_FULLSCREEN, FALSE);
  allegro_gl_set (AGL_DOUBLEBUFFER, 1);
  allegro_gl_set (AGL_SUGGEST, AGL_COLOR_DEPTH | AGL_Z_DEPTH | AGL_DOUBLEBUFFER
		  | AGL_FULLSCREEN);
}
void shutdown_gl() {

}

